load('meanM.mat');
load('stdM.mat');

%% protrusion fig (Traj centered)
% figure;
% hold on
% plot(mean(meanM,2),'b','linewidth',2)
% stdM = std(meanM,0,2);
% plot(mean(meanM,2)+stdM,'--b','linewidth',0.5)
% plot(mean(meanM,2)-stdM,'--b','linewidth',0.5)

%% protrusion fig (Traj centered) in um/h
figure;
hold on
pixelSize = 0.2167; % um/pixel
timeHour = 60/5; % images were taken every 5 min
meanMScaled = meanM * pixelSize * timeHour;
plot(mean(meanMScaled,2),'Color',[0 0.4470 0.7410],'linewidth',3)
stdM = std(meanMScaled,0,2);
plot(mean(meanMScaled,2)+stdM,'--','Color',[0 0.4470 0.7410],'linewidth',1)
plot(mean(meanMScaled,2)-stdM,'--','Color',[0 0.4470 0.7410],'linewidth',1)
xticks([0 25 50 75 100])
xticklabels({'0','', '0.5', '', '1'})
line([50 50], [-20 30],'Color','k','LineStyle','-.','linewidth', 1); % constant x line
ylabel('Average protrusion speed (m/hr)')
set(gca,'FontSize',16,'fontweight','bold')
% a nice box around
 box on
set(gcf,'color','w');

%% rotate figure (flip the Y axis)
% set(gca,'YDir','reverse');

%% rotate figure (rotate 90 degrees)
camroll(-90) % can rotate multiple times







